/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.mule.MessagePropertiesContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.AbstractMuleTestCase;

public class MessagePropertiesContextTestCase
extends AbstractMuleTestCase {
    public void doTearDown() {
        RequestContext.clear();
    }

    public void testPropertiesCase() throws Exception {
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("FOO", (Object)"BAR", PropertyScope.OUTBOUND);
        mpc.setProperty("ABC", (Object)"abc", PropertyScope.OUTBOUND);
        mpc.setProperty("DOO", (Object)"DAR", PropertyScope.INVOCATION);
        this.doTest(mpc);
    }

    public void testSessionScope() throws Exception {
        MuleEvent e = MessagePropertiesContextTestCase.getTestEvent("testing");
        e.getSession().setProperty("SESSION_PROP", (Object)"Value1");
        RequestContext.setEvent((MuleEvent)e);
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        MessagePropertiesContextTestCase.assertEquals((Object)"Value1", (Object)mpc.getProperty("SESSION_PROP", PropertyScope.SESSION));
        MessagePropertiesContextTestCase.assertEquals((Object)"Value1", (Object)mpc.getProperty("SESSION_prop", PropertyScope.SESSION));
        MessagePropertiesContextTestCase.assertNull((Object)mpc.getProperty("SESSION_X", PropertyScope.SESSION));
    }

    public void testPropertyScopeOrder() throws Exception {
        MuleEvent e = MessagePropertiesContextTestCase.getTestEvent("testing");
        e.getSession().setProperty("Prop", (Object)"session");
        RequestContext.setEvent((MuleEvent)e);
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("Prop", (Object)"invocation", PropertyScope.INVOCATION);
        mpc.setProperty("Prop", (Object)"outbound", PropertyScope.OUTBOUND);
        MessagePropertiesContextTestCase.assertEquals((Object)"outbound", (Object)mpc.getProperty("Prop", PropertyScope.OUTBOUND));
        mpc.removeProperty("Prop", PropertyScope.OUTBOUND);
        MessagePropertiesContextTestCase.assertEquals((Object)"invocation", (Object)mpc.getProperty("Prop", PropertyScope.INVOCATION));
        mpc.removeProperty("Prop", PropertyScope.INVOCATION);
        MessagePropertiesContextTestCase.assertEquals((Object)"session", (Object)mpc.getProperty("Prop", PropertyScope.SESSION));
        MessagePropertiesContextTestCase.assertNull((Object)mpc.getProperty("Prop", PropertyScope.INBOUND));
        MessagePropertiesContextTestCase.assertNull((Object)mpc.getProperty("Prop", PropertyScope.INVOCATION));
        MessagePropertiesContextTestCase.assertNull((Object)mpc.getProperty("Prop", PropertyScope.OUTBOUND));
    }

    public void testPropertiesCaseAfterSerialization() throws Exception {
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("FOO", (Object)"BAR", PropertyScope.OUTBOUND);
        mpc.setProperty("ABC", (Object)"abc", PropertyScope.OUTBOUND);
        mpc.setProperty("DOO", (Object)"DAR", PropertyScope.INVOCATION);
        this.doTest(mpc);
        byte[] bytes = SerializationUtils.serialize((Serializable)mpc);
        mpc = (MessagePropertiesContext)SerializationUtils.deserialize((byte[])bytes);
        this.doTest(mpc);
    }

    protected void doTest(MessagePropertiesContext mpc) {
        MessagePropertiesContextTestCase.assertEquals((Object)"BAR", (Object)mpc.getProperty("foo", PropertyScope.OUTBOUND));
        MessagePropertiesContextTestCase.assertEquals((Object)"DAR", (Object)mpc.getProperty("doo", PropertyScope.INVOCATION));
        MessagePropertiesContextTestCase.assertEquals((Object)"abc", (Object)mpc.getProperty("abc", PropertyScope.OUTBOUND));
        MessagePropertiesContextTestCase.assertEquals((Object)"BAR", (Object)mpc.getProperty("foO", PropertyScope.OUTBOUND));
        MessagePropertiesContextTestCase.assertEquals((Object)"DAR", (Object)mpc.getProperty("doO", PropertyScope.INVOCATION));
        MessagePropertiesContextTestCase.assertNull((Object)mpc.getProperty("doo", PropertyScope.INBOUND));
        MessagePropertiesContextTestCase.assertNull((Object)mpc.getProperty("doo", PropertyScope.OUTBOUND));
        MessagePropertiesContextTestCase.assertNull((Object)mpc.getProperty("doo", PropertyScope.SESSION));
        Set keys = mpc.getPropertyNames();
        MessagePropertiesContextTestCase.assertEquals((int)3, (int)keys.size());
        for (String key : keys) {
            MessagePropertiesContextTestCase.assertTrue((key.equals("FOO") || key.equals("DOO") || key.equals("ABC") ? 1 : 0) != 0);
            MessagePropertiesContextTestCase.assertFalse((key.equals("foo") || key.equals("doo") || key.equals("abc") ? 1 : 0) != 0);
        }
    }
}

