/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import java.lang.reflect.Method;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.Enhancer;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodProxy;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.ReflectionEntryPointResolver;
import org.mule.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitLover;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;
import org.mule.transport.NullPayload;

public class ReflectionEntryPointResolverTestCase
extends AbstractMuleTestCase {
    public void testExplicitMethodMatch() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new WaterMelon(), ReflectionEntryPointResolverTestCase.getTestEventContext("blah"));
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public void testExplicitMethodMatchComplexObject() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new FruitLover("Mmmm")));
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public void testMethodMatchWithArguments() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Object[]{new Apple(), new Banana()}));
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(result.getResult() instanceof Fruit[]));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[0] instanceof Apple));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[1] instanceof Banana));
        ReflectionEntryPointResolverTestCase.assertEquals((String)"addAppleAndBanana", (String)result.getMethodCalled());
        result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Object[]{new Banana(), new Apple()}));
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(result.getResult() instanceof Fruit[]));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[0] instanceof Banana));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[1] instanceof Apple));
        ReflectionEntryPointResolverTestCase.assertEquals((String)"addBananaAndApple", (String)result.getMethodCalled());
    }

    public void testExplicitMethodMatchSetArrayFail() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Fruit[]{new Apple(), new Orange()}));
        ReflectionEntryPointResolverTestCase.assertEquals((String)"Test should have failed because the arguments were not wrapped properly: ", (Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    public void testExplicitMethodMatchSetArrayPass() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Object[]{new Fruit[]{new Apple(), new Orange()}}));
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public void testFailEntryPointMultiplePayloadMatches() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        RequestContext.setEvent((MuleEvent)ReflectionEntryPointResolverTestCase.getTestEvent("Hello"));
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), RequestContext.getEventContext());
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    public void testMatchOnNoArgs() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new Kiwi(), ReflectionEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance()));
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
        resolver.setAcceptVoidMethods(true);
        result = resolver.invoke((Object)new Kiwi(), ReflectionEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance()));
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        ReflectionEntryPointResolverTestCase.assertEquals((String)"bite", (String)result.getMethodCalled());
    }

    public void testAnnotatedMethodOnProxyWithMethodSet() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        Enhancer e = new Enhancer();
        e.setSuperclass(WaterMelon.class);
        e.setCallback((Callback)new DummyMethodCallback());
        Object proxy = e.create();
        MuleEventContext context = ReflectionEntryPointResolverTestCase.getTestEventContext("Blah");
        InvocationResult result = resolver.invoke(proxy, context);
        ReflectionEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    private class DummyMethodCallback
    implements MethodInterceptor {
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            System.out.println("before: " + method.getName());
            Object r = proxy.invokeSuper(obj, args);
            System.out.println("after: " + method.getName());
            return r;
        }
    }
}

