/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.registry.Registry;
import org.mule.construct.SimpleFlowConstruct;
import org.mule.registry.TransientRegistry;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;

public class RegistryBrokerTestCase
extends AbstractMuleTestCase {
    private String tracker;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tracker = new String();
    }

    protected boolean isStartContext() {
        return false;
    }

    public void testCrossRegistryLifecycleOrder() throws MuleException {
        TransientRegistry reg1 = new TransientRegistry(muleContext);
        reg1.initialise();
        TransientRegistry reg2 = new TransientRegistry(muleContext);
        reg2.initialise();
        reg1.registerObject("conn", (Object)new LifecycleTrackerConnector("conn", muleContext));
        reg2.registerObject("conn2", (Object)new LifecycleTrackerConnector("conn2", muleContext));
        reg1.registerObject("flow", (Object)new LifecycleTrackerFlow("flow", muleContext));
        reg2.registerObject("flow2", (Object)new LifecycleTrackerFlow("flow2", muleContext));
        muleContext.addRegistry((Registry)reg1);
        muleContext.addRegistry((Registry)reg2);
        muleContext.start();
        RegistryBrokerTestCase.assertEquals((String)"conn2-start conn-start flow2-start flow-start ", (String)this.tracker.toString());
        this.tracker = new String();
        muleContext.stop();
        RegistryBrokerTestCase.assertEquals((String)"flow2-stop flow-stop conn2-stop conn-stop ", (String)this.tracker);
    }

    class LifecycleTrackerFlow
    extends SimpleFlowConstruct {
        public LifecycleTrackerFlow(String name, MuleContext muleContext) {
            super(name, muleContext);
        }

        protected void doStart() throws MuleException {
            super.doStart();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-start ");
        }

        protected void doStop() throws MuleException {
            super.doStop();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-stop ");
        }
    }

    class LifecycleTrackerConnector
    extends TestConnector {
        public LifecycleTrackerConnector(String name, MuleContext context) {
            super(context);
            this.name = name;
        }

        protected void doStart() {
            super.doStart();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-start ");
        }

        protected void doStop() {
            super.doStop();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-stop ");
        }
    }
}

