/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.AbstractSplitter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;

public class AbstractSplitterTestCase
extends AbstractMuleTestCase {
    public void testSimpleSplitter() throws Exception {
        TestSplitter splitter = new TestSplitter();
        MultipleEventSensingMessageProcessor listener = new MultipleEventSensingMessageProcessor();
        splitter.setListener(listener);
        splitter.setMuleContext(muleContext);
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit(apple);
        fruitBowl.addFruit(banana);
        fruitBowl.addFruit(orange);
        DefaultMuleEvent inEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)fruitBowl, muleContext), AbstractSplitterTestCase.getTestEvent(""));
        MuleEvent resultEvent = splitter.process((MuleEvent)inEvent);
        AbstractSplitterTestCase.assertEquals((int)3, (int)listener.events.size());
        AbstractSplitterTestCase.assertTrue((boolean)(listener.events.get(0).getMessage().getPayload() instanceof Fruit));
        AbstractSplitterTestCase.assertTrue((boolean)(listener.events.get(1).getMessage().getPayload() instanceof Fruit));
        AbstractSplitterTestCase.assertTrue((boolean)(listener.events.get(2).getMessage().getPayload() instanceof Fruit));
        AbstractSplitterTestCase.assertEquals(DefaultMessageCollection.class, resultEvent.getMessage().getClass());
        AbstractSplitterTestCase.assertEquals((int)3, (int)((MuleMessageCollection)resultEvent.getMessage()).size());
        AbstractSplitterTestCase.assertTrue((boolean)(((MuleMessageCollection)resultEvent.getMessage()).getMessage(0).getPayload() instanceof Fruit));
        AbstractSplitterTestCase.assertTrue((boolean)(((MuleMessageCollection)resultEvent.getMessage()).getMessage(1).getPayload() instanceof Fruit));
        AbstractSplitterTestCase.assertTrue((boolean)(((MuleMessageCollection)resultEvent.getMessage()).getMessage(2).getPayload() instanceof Fruit));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestSplitter
    extends AbstractSplitter {
        private TestSplitter() {
        }

        protected List<MuleMessage> splitMessage(MuleEvent event) {
            FruitBowl bowl = (FruitBowl)event.getMessage().getPayload();
            ArrayList<MuleMessage> parts = new ArrayList<MuleMessage>();
            for (Fruit fruit : bowl.getFruit()) {
                parts.add((MuleMessage)new DefaultMuleMessage((Object)fruit, this.muleContext));
            }
            return parts;
        }
    }

    private static class MultipleEventSensingMessageProcessor
    implements MessageProcessor {
        List<MuleEvent> events = new ArrayList<MuleEvent>();

        private MultipleEventSensingMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.events.add(event);
            return event;
        }
    }
}

