/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.routing.EventGroup;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.UUID;

public class EventGroupTestCase
extends AbstractMuleTestCase {
    public EventGroupTestCase() {
        this.setStartContext(true);
    }

    public void testConcurrentIteration() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID());
        EventGroupTestCase.assertFalse((boolean)eg.iterator().hasNext());
        eg.addEvent(EventGroupTestCase.getTestEvent("foo1"));
        eg.addEvent(EventGroupTestCase.getTestEvent("foo2"));
        EventGroupTestCase.assertTrue((boolean)eg.iterator().hasNext());
        Iterator i = eg.iterator();
        EventGroupTestCase.assertNotNull(i.next());
        eg.addEvent(EventGroupTestCase.getTestEvent("foo3"));
        EventGroupTestCase.assertNotNull(i.next());
        eg.addEvent(EventGroupTestCase.getTestEvent("foo4"));
        EventGroupTestCase.assertFalse((boolean)i.hasNext());
        EventGroupTestCase.assertEquals((int)4, (int)eg.size());
    }

    public void testEquals() {
        EventGroup g1 = new EventGroup((Object)"foo");
        EventGroup g2 = new EventGroup((Object)"foo");
        EventGroup g3 = new EventGroup((Object)"bar");
        EventGroupTestCase.assertEquals((Object)g1, (Object)g2);
        EventGroupTestCase.assertFalse((boolean)g1.equals((Object)g3));
        MyEventGroup mg = new MyEventGroup("foo");
        EventGroupTestCase.assertEquals((Object)g1, (Object)((Object)mg));
        EventGroupTestCase.assertEquals((Object)((Object)mg), (Object)g1);
        mg = new MyEventGroup("bar");
        EventGroupTestCase.assertFalse((boolean)g1.equals((Object)mg));
        EventGroupTestCase.assertFalse((boolean)mg.equals(g1));
    }

    public void testHashCode() {
        String uuid = UUID.getUUID();
        EventGroup g1 = new EventGroup((Object)uuid);
        EventGroup g2 = new EventGroup((Object)uuid);
        EventGroup g3 = new EventGroup((Object)UUID.getUUID());
        EventGroupTestCase.assertEquals((int)g1.hashCode(), (int)g2.hashCode());
        EventGroupTestCase.assertEquals((Object)g1, (Object)g2);
        EventGroupTestCase.assertFalse((g1.hashCode() == g3.hashCode() ? 1 : 0) != 0);
        EventGroupTestCase.assertFalse((boolean)g1.equals((Object)g3));
        EventGroupTestCase.assertFalse((boolean)g3.equals((Object)g1));
        HashSet<EventGroup> s = new HashSet<EventGroup>();
        s.add(g1);
        EventGroupTestCase.assertTrue((boolean)s.contains(g1));
        EventGroupTestCase.assertEquals((int)1, (int)s.size());
        EventGroupTestCase.assertTrue((boolean)s.contains(g2));
        EventGroupTestCase.assertEquals((int)1, (int)s.size());
        EventGroupTestCase.assertFalse((boolean)s.contains(g3));
        EventGroupTestCase.assertTrue((boolean)s.add(g3));
        EventGroupTestCase.assertTrue((boolean)s.contains(g3));
        EventGroupTestCase.assertEquals((int)2, (int)s.size());
    }

    public void testCompareTo() throws InterruptedException {
        String uuid = UUID.getUUID();
        EventGroup g1 = new EventGroup((Object)uuid);
        EventGroup g2 = new EventGroup((Object)uuid);
        EventGroup g3 = new EventGroup((Object)UUID.getUUID());
        try {
            g1.compareTo(null);
            EventGroupTestCase.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        EventGroupTestCase.assertEquals((int)0, (int)g1.compareTo(g2));
        EventGroupTestCase.assertTrue((g1.compareTo(g3) != 0 ? 1 : 0) != 0);
        EventGroupTestCase.assertTrue((g3.compareTo(g1) != 0 ? 1 : 0) != 0);
        EventGroupTestCase.assertTrue((g3.compareTo(g2) != 0 ? 1 : 0) != 0);
        g1 = new EventGroup(new Object());
        Thread.sleep(10L);
        g2 = new EventGroup(new Object());
        EventGroupTestCase.assertTrue((g1.compareTo(g2) < 0 ? 1 : 0) != 0);
        EventGroupTestCase.assertTrue((g2.compareTo(g1) > 0 ? 1 : 0) != 0);
    }

    public void testToArray() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID());
        eg.addEvent(EventGroupTestCase.getTestEvent("foo1"));
        eg.addEvent(EventGroupTestCase.getTestEvent("foo2"));
        Object[] array1 = IteratorUtils.toArray((Iterator)eg.iterator());
        Object[] array2 = eg.toArray();
        EventGroupTestCase.assertTrue((boolean)Arrays.equals(array1, array2));
    }

    public void testToString() throws Exception {
        EventGroup eg = new EventGroup((Object)UUID.getUUID());
        String es = eg.toString();
        EventGroupTestCase.assertTrue((boolean)es.endsWith("events=0}"));
        MuleEvent e = EventGroupTestCase.getTestEvent("foo");
        eg.addEvent(e);
        es = eg.toString();
        EventGroupTestCase.assertTrue((es.indexOf("events=1") != -1 ? 1 : 0) != 0);
        EventGroupTestCase.assertTrue((boolean)es.endsWith("[" + e.getMessage().getUniqueId() + "]}"));
        DefaultMuleEvent e2 = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"foo2", muleContext), e);
        eg.addEvent((MuleEvent)e2);
        es = eg.toString();
        EventGroupTestCase.assertTrue((es.indexOf("events=2") != -1 ? 1 : 0) != 0);
        EventGroupTestCase.assertTrue((boolean)es.endsWith(e.getMessage().getUniqueId() + ", " + e2.getMessage().getUniqueId() + "]}"));
    }

    private static class MyEventGroup
    extends EventGroup {
        private static final long serialVersionUID = 1L;

        public MyEventGroup(Object groupId) {
            super(groupId);
        }

        public MyEventGroup(Object groupId, int expectedSize) {
            super(groupId, expectedSize);
        }
    }
}

