/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.routing.MapSplitter;
import org.mule.tck.AbstractMuleTestCase;

public class MapSplitterTestCase
extends AbstractMuleTestCase {
    private MapSplitter mapSplitter;
    private List<String> splitPayloads = new ArrayList<String>();
    private List<String> splitKeyProperties = new ArrayList<String>();

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.mapSplitter = new MapSplitter();
        this.mapSplitter.setMuleContext(muleContext);
        this.mapSplitter.setListener(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                MapSplitterTestCase.this.splitPayloads.add(event.getMessageAsString());
                MapSplitterTestCase.this.splitKeyProperties.add((String)event.getMessage().getProperty(MapSplitter.MAP_ENTRY_KEY, PropertyScope.INVOCATION));
                return event;
            }
        });
    }

    public void testSplit() throws Exception {
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("1", "one");
        testMap.put("2", "two");
        testMap.put("3", "three");
        this.mapSplitter.process(MapSplitterTestCase.getTestEvent(testMap));
        MapSplitterTestCase.assertEquals((int)3, (int)this.splitPayloads.size());
        MapSplitterTestCase.assertTrue((boolean)this.splitPayloads.contains("one"));
        MapSplitterTestCase.assertTrue((boolean)this.splitPayloads.contains("two"));
        MapSplitterTestCase.assertTrue((boolean)this.splitPayloads.contains("three"));
        MapSplitterTestCase.assertEquals((int)3, (int)this.splitPayloads.size());
        MapSplitterTestCase.assertEquals((String)"1", (String)this.splitKeyProperties.get(this.splitPayloads.indexOf("one")));
        MapSplitterTestCase.assertEquals((String)"2", (String)this.splitKeyProperties.get(this.splitPayloads.indexOf("two")));
        MapSplitterTestCase.assertEquals((String)"3", (String)this.splitKeyProperties.get(this.splitPayloads.indexOf("three")));
    }
}

