/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.service.Service;
import org.mule.routing.SimpleCollectionAggregator;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;

public class SimpleCollectionAggregatorTestCase
extends AbstractMuleTestCase {
    public SimpleCollectionAggregatorTestCase() {
        this.setStartContext(true);
    }

    public void testMessageProcessor() throws Exception {
        MuleSession session = SimpleCollectionAggregatorTestCase.getTestSession(SimpleCollectionAggregatorTestCase.getTestService(), muleContext);
        Service testService = SimpleCollectionAggregatorTestCase.getTestService("test", Apple.class);
        SimpleCollectionAggregatorTestCase.assertNotNull((Object)testService);
        SimpleCollectionAggregator router = new SimpleCollectionAggregator();
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        message1.setCorrelationId(message1.getUniqueId());
        message2.setCorrelationId(message1.getUniqueId());
        message3.setCorrelationId(message1.getUniqueId());
        message1.setCorrelationGroupSize(3);
        OutboundEndpoint endpoint = MuleTestUtils.getTestOutboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, (ImmutableEndpoint)endpoint, session);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, (ImmutableEndpoint)endpoint, session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, (ImmutableEndpoint)endpoint, session);
        SimpleCollectionAggregatorTestCase.assertNull((Object)router.process((MuleEvent)event1));
        SimpleCollectionAggregatorTestCase.assertNull((Object)router.process((MuleEvent)event2));
        MuleEvent resultEvent = router.process((MuleEvent)event3);
        SimpleCollectionAggregatorTestCase.assertNotNull((Object)resultEvent);
        MuleMessage resultMessage = resultEvent.getMessage();
        SimpleCollectionAggregatorTestCase.assertNotNull((Object)resultMessage);
        List payload = (List)resultMessage.getPayload();
        SimpleCollectionAggregatorTestCase.assertEquals((int)3, (int)payload.size());
        SimpleCollectionAggregatorTestCase.assertEquals((String)"test event A", (String)((String)payload.get(0)));
        SimpleCollectionAggregatorTestCase.assertEquals((String)"test event B", (String)((String)payload.get(1)));
        SimpleCollectionAggregatorTestCase.assertEquals((String)"test event C", (String)((String)payload.get(2)));
    }
}

