/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.routing.filters.RegExFilter;
import org.mule.tck.AbstractMuleTestCase;

public class RegExFilterTestCase
extends AbstractMuleTestCase {
    private static final String PATTERN = "(.*) brown fox";

    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        RegExFilterTestCase.assertNull((Object)filter.getPattern());
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern(PATTERN);
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    public void testRegexFilter() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        RegExFilterTestCase.assertNotNull((Object)filter.getPattern());
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick "));
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"he quick brown fox"));
        filter.setPattern(PATTERN);
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)" brown fox"));
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("(.*) brown (.*)");
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)PATTERN));
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"The quickbrown fox"));
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("(.*)");
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
    }

    public void testNullInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        RegExFilterTestCase.assertNotNull((Object)filter.getPattern());
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)null));
    }

    public void testMuleMessageInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        RegExFilterTestCase.assertNotNull((Object)filter.getPattern());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"The quick brown fox", muleContext);
        RegExFilterTestCase.assertTrue((boolean)filter.accept((MuleMessage)message));
    }

    public void testByteArrayInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        RegExFilterTestCase.assertNotNull((Object)filter.getPattern());
        byte[] bytes = "The quick brown fox".getBytes();
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)bytes));
    }

    public void testCharArrayInput() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        RegExFilterTestCase.assertNotNull((Object)filter.getPattern());
        char[] chars = "The quick brown fox".toCharArray();
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)chars));
    }

    public void testEqualsWithSamePattern() {
        RegExFilter filter1 = new RegExFilter(PATTERN);
        RegExFilter filter2 = new RegExFilter(PATTERN);
        RegExFilterTestCase.assertEquals((Object)filter1, (Object)filter2);
    }

    public void testEqualsWithDifferentPattern() {
        RegExFilter filter1 = new RegExFilter("foo");
        RegExFilter filter2 = new RegExFilter("bar");
        RegExFilterTestCase.assertFalse((boolean)filter1.equals((Object)filter2));
    }

    public void testEqualsWithEqualPatternAndDifferentFlags() {
        RegExFilter filter1 = new RegExFilter(PATTERN, 32);
        RegExFilter filter2 = new RegExFilter(PATTERN, 2);
        RegExFilterTestCase.assertFalse((boolean)filter1.equals((Object)filter2));
        filter1 = new RegExFilter(PATTERN, 32);
        filter2 = new RegExFilter(PATTERN, 32);
        RegExFilterTestCase.assertEquals((Object)filter1, (Object)filter2);
    }
}

