/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.HashMap;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.EndpointSelector;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class EndpointSelectorTestCase
extends AbstractMuleTestCase {
    Mock session;
    OutboundEndpoint dest1;
    OutboundEndpoint dest2;
    OutboundEndpoint dest3;
    EndpointSelector router;
    Mock mockendpoint1;
    Mock mockendpoint2;
    Mock mockendpoint3;

    public EndpointSelectorTestCase() {
        this.setStartContext(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = MuleTestUtils.getMockSession();
        this.session.matchAndReturn("getFlowConstruct", (Object)EndpointSelectorTestCase.getTestService());
        this.dest1 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest1");
        this.dest2 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest2");
        this.dest3 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest3");
        this.mockendpoint1 = RouterTestUtils.getMockEndpoint(this.dest1);
        this.mockendpoint2 = RouterTestUtils.getMockEndpoint(this.dest2);
        this.mockendpoint3 = RouterTestUtils.getMockEndpoint(this.dest3);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)this.mockendpoint1.proxy());
        endpoints.add((OutboundEndpoint)this.mockendpoint2.proxy());
        endpoints.add((OutboundEndpoint)this.mockendpoint3.proxy());
        this.router = new EndpointSelector();
        this.router.setRoutes(endpoints);
        this.router.setMuleContext(muleContext);
        this.router.initialise();
    }

    public void testSelectEndpointDefaultProperty() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("apple", "red");
        props.put("endpoint", "dest3");
        props.put("banana", "yellow");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
        EndpointSelectorTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        this.mockendpoint3.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
        this.mockendpoint3.verify();
    }

    public void testSelectEndpointCustomProperty() throws Exception {
        this.router.setExpression("wayOut");
        this.router.setEvaluator("header");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("apple", "red");
        props.put("wayOut", "dest2");
        props.put("banana", "yellow");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
        EndpointSelectorTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        this.mockendpoint2.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
        this.mockendpoint2.verify();
    }

    public void testSelectEndpointNoMatch() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("endpoint", "dest5");
        try {
            DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
            this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
            EndpointSelectorTestCase.fail((String)"Router should have thrown an exception if endpoint was not found.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSelectEndpointNoMatchUseDefault() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        this.router.setDefaultEndpointName("dest3");
        EndpointSelectorTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        this.mockendpoint3.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
        this.mockendpoint3.verify();
    }

    public void testSelectEndpointNoPropertySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        try {
            this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
            EndpointSelectorTestCase.fail((String)"Router should have thrown an exception if no selector property was set on the message.");
        }
        catch (RoutingException routingException) {
            // empty catch block
        }
    }
}

