/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortUtils {
    private static final int MIN_PORT = 5000;
    private static final int MAX_PORT = 6000;
    static final Log logger = LogFactory.getLog(PortUtils.class);

    public static List<Integer> findFreePorts(int numberOfPorts) {
        ArrayList<Integer> freePorts = new ArrayList<Integer>();
        for (int port = 5000; freePorts.size() != numberOfPorts && port < 6000; ++port) {
            if (!PortUtils.isPortFree(port)) continue;
            freePorts.add(port);
        }
        if (freePorts.size() != numberOfPorts) {
            logger.info((Object)("requested " + numberOfPorts + " open ports, but returning " + freePorts.size()));
        }
        return freePorts;
    }

    public static void checkPorts(boolean failIfTaken, String prefix, List<Integer> ports) throws Exception {
        for (Integer port : ports) {
            if (PortUtils.isPortFree(port)) {
                logger.info((Object)(prefix + " port is free : " + port));
                continue;
            }
            logger.info((Object)(prefix + " port is not free : " + port));
            if (!failIfTaken) continue;
            throw new Exception("port is not free : " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortFree(int port) {
        boolean portIsFree = true;
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
        }
        catch (IOException e) {
            portIsFree = false;
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException iOException) {}
            }
        }
        return portIsFree;
    }
}

