/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transformer.simple.ObjectToInputStream;
import org.mule.util.IOUtils;

public class ObjectToInputStreamTestCase
extends AbstractMuleTestCase {
    private ObjectToInputStream transformer = new ObjectToInputStream();

    public void testTransformString() throws TransformerException, IOException {
        ObjectToInputStreamTestCase.assertTrue((boolean)InputStream.class.isAssignableFrom(this.transformer.transform((Object)"Test Message").getClass()));
        ObjectToInputStreamTestCase.assertTrue((boolean)ObjectToInputStreamTestCase.compare(new ByteArrayInputStream("Test Message".getBytes()), (InputStream)this.transformer.transform((Object)"Test Message")));
    }

    public void testTransformByteArray() throws TransformerException, IOException {
        ObjectToInputStreamTestCase.assertTrue((boolean)InputStream.class.isAssignableFrom(this.transformer.transform((Object)"Test Message".getBytes()).getClass()));
        ObjectToInputStreamTestCase.assertTrue((boolean)ObjectToInputStreamTestCase.compare(new ByteArrayInputStream("Test Message".getBytes()), (InputStream)this.transformer.transform((Object)"Test Message")));
    }

    public void testTransformInputStream() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Test Message".getBytes());
        try {
            ObjectToInputStreamTestCase.assertEquals((Object)inputStream, (Object)this.transformer.transform((Object)inputStream));
        }
        catch (Exception e) {
            ObjectToInputStreamTestCase.assertTrue((boolean)(e instanceof TransformerException));
            ObjectToInputStreamTestCase.assertTrue((boolean)e.getMessage().contains("does not support source type"));
        }
    }

    public void testTransformSerializable() {
        Apple apple = new Apple();
        ByteArrayInputStream serializedApple = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)apple));
        try {
            ObjectToInputStreamTestCase.assertTrue((boolean)ObjectToInputStreamTestCase.compare(serializedApple, (InputStream)this.transformer.transform((Object)apple)));
        }
        catch (Exception e) {
            ObjectToInputStreamTestCase.assertTrue((boolean)(e instanceof TransformerException));
            ObjectToInputStreamTestCase.assertTrue((boolean)e.getMessage().contains("does not support source type"));
        }
    }

    public static boolean compare(InputStream input1, InputStream input2) {
        byte[] bytes1 = IOUtils.toByteArray((InputStream)input1);
        byte[] bytes2 = IOUtils.toByteArray((InputStream)input2);
        return Arrays.equals(bytes1, bytes2);
    }
}

