/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;

public class DispatcherThreadingProfileTestCase
extends AbstractMuleTestCase {
    public static int DELAY_TIME = 500;
    public static int WAIT_TIME = DELAY_TIME + DELAY_TIME / 4;
    public static int SERIAL_WAIT_TIME = DELAY_TIME * 2 + DELAY_TIME / 4;
    public static int LONGER_WAIT_TIME = DELAY_TIME * 5;
    private CountDownLatch latch;
    private AtomicInteger counter = new AtomicInteger();

    public DispatcherThreadingProfileTestCase() {
        this.setStartContext(true);
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.counter.set(0);
    }

    public void testDefaultThreadingProfileConfiguration() throws MuleException {
        TestConnector connector = new TestConnector(muleContext);
        muleContext.getRegistry().registerConnector((Connector)connector);
        DispatcherThreadingProfileTestCase.assertEquals((int)16, (int)connector.getDispatcherThreadingProfile().getMaxThreadsActive());
        DispatcherThreadingProfileTestCase.assertEquals((int)1, (int)connector.getDispatcherThreadingProfile().getMaxThreadsIdle());
        DispatcherThreadingProfileTestCase.assertEquals((int)4, (int)connector.getDispatcherThreadingProfile().getPoolExhaustedAction());
        DispatcherThreadingProfileTestCase.assertEquals((int)0, (int)connector.getDispatcherThreadingProfile().getMaxBufferSize());
        DispatcherThreadingProfileTestCase.assertEquals((long)60000L, (long)connector.getDispatcherThreadingProfile().getThreadTTL());
        DispatcherThreadingProfileTestCase.assertEquals((long)30000L, (long)connector.getDispatcherThreadingProfile().getThreadWaitTimeout());
    }

    public void testDefaultRunExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(2);
        this.createTestConnectorWithSingleDispatcherThread(4);
        this.dispatchTwoAsyncEvents();
        DispatcherThreadingProfileTestCase.assertTrue((boolean)this.latch.await((long)WAIT_TIME, TimeUnit.MILLISECONDS));
    }

    public void testWaitExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(2);
        this.createTestConnectorWithSingleDispatcherThread(1, 0, 30000L, 0);
        this.dispatchTwoAsyncEvents();
        DispatcherThreadingProfileTestCase.assertTrue((boolean)this.latch.await((long)SERIAL_WAIT_TIME, TimeUnit.MILLISECONDS));
    }

    public void testWaitTimeoutExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(1);
        this.createTestConnectorWithSingleDispatcherThread(0);
        this.dispatchTwoAsyncEvents();
        DispatcherThreadingProfileTestCase.assertTrue((boolean)this.latch.await((long)WAIT_TIME, TimeUnit.MILLISECONDS));
        Thread.sleep(LONGER_WAIT_TIME);
        DispatcherThreadingProfileTestCase.assertEquals((int)1, (int)this.counter.get());
    }

    public void testAbortExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(1);
        this.createTestConnectorWithSingleDispatcherThread(3);
        this.dispatchTwoAsyncEvents();
        DispatcherThreadingProfileTestCase.assertTrue((boolean)this.latch.await((long)WAIT_TIME, TimeUnit.MILLISECONDS));
        Thread.sleep(LONGER_WAIT_TIME);
        DispatcherThreadingProfileTestCase.assertEquals((int)1, (int)this.counter.get());
    }

    public void testDiscardExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(1);
        this.createTestConnectorWithSingleDispatcherThread(1);
        this.dispatchTwoAsyncEvents();
        DispatcherThreadingProfileTestCase.assertTrue((boolean)this.latch.await((long)WAIT_TIME, TimeUnit.MILLISECONDS));
        Thread.sleep(LONGER_WAIT_TIME);
        DispatcherThreadingProfileTestCase.assertEquals((int)1, (int)this.counter.get());
    }

    public void testDiscardOldestExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(3);
        this.createTestConnectorWithSingleDispatcherThread(2, 2, 30000L, 1);
        this.dispatchTwoAsyncEvents();
        this.dispatchTwoAsyncEvents();
        this.dispatchTwoAsyncEvents();
        DispatcherThreadingProfileTestCase.assertTrue((boolean)this.latch.await((long)SERIAL_WAIT_TIME, TimeUnit.MILLISECONDS));
        Thread.sleep(LONGER_WAIT_TIME);
        DispatcherThreadingProfileTestCase.assertEquals((int)3, (int)this.counter.get());
    }

    protected void createTestConnectorWithSingleDispatcherThread(int exhaustedAction) throws MuleException {
        this.createTestConnectorWithSingleDispatcherThread(1, exhaustedAction, 1L, 1);
    }

    protected void createTestConnectorWithSingleDispatcherThread(int threads, int exhaustedAction, long waitTimeout, int maxBufferSize) throws MuleException {
        TestConnector connector = new TestConnector(muleContext);
        ImmutableThreadingProfile threadingProfile = new ImmutableThreadingProfile(threads, threads, maxBufferSize, 60000L, waitTimeout, exhaustedAction, true, null, null);
        threadingProfile.setMuleContext(muleContext);
        connector.setDispatcherThreadingProfile((ThreadingProfile)threadingProfile);
        muleContext.getRegistry().registerConnector((Connector)connector);
        connector.setDispatcherFactory((MessageDispatcherFactory)new DelayTestMessageDispatcherFactory());
    }

    private void dispatchTwoAsyncEvents() throws DispatchException, Exception {
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("test://test");
        endpoint.process(DispatcherThreadingProfileTestCase.getTestEvent((Object)"data", (ImmutableEndpoint)endpoint));
        endpoint.process(DispatcherThreadingProfileTestCase.getTestEvent((Object)"data", (ImmutableEndpoint)endpoint));
    }

    class DelayTestMessageDispatcherFactory
    extends TestMessageDispatcherFactory {
        DelayTestMessageDispatcherFactory() {
        }

        public MessageDispatcher create(OutboundEndpoint endpoint) throws MuleException {
            return new DelayTestMessageDispatcher(endpoint);
        }
    }

    public class DelayTestMessageDispatcher
    extends TestMessageDispatcher {
        public DelayTestMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        protected void doDispatch(MuleEvent event) throws Exception {
            super.doDispatch(event);
            Thread.sleep(DELAY_TIME);
            DispatcherThreadingProfileTestCase.this.counter.incrementAndGet();
            DispatcherThreadingProfileTestCase.this.latch.countDown();
        }
    }
}

