/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Test;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.CaseInsensitiveHashMap;

public class CaseInsensitiveHashMapTestCase
extends AbstractMuleTestCase {
    protected CaseInsensitiveHashMap createTestMap() {
        CaseInsensitiveHashMap map = new CaseInsensitiveHashMap();
        map.put((Object)"FOO", (Object)"BAR");
        map.put((Object)"DOO", (Object)3);
        return map;
    }

    @Test
    public void testMap() throws Exception {
        CaseInsensitiveHashMap map = this.createTestMap();
        this.doTestMap(map);
    }

    @Test
    public void testMapSerialization() throws Exception {
        CaseInsensitiveHashMap map = this.createTestMap();
        this.doTestMap(map);
        byte[] bytes = SerializationUtils.serialize((Serializable)map);
        CaseInsensitiveHashMap resultMap = (CaseInsensitiveHashMap)SerializationUtils.deserialize((byte[])bytes);
        this.doTestMap(resultMap);
    }

    public void doTestMap(CaseInsensitiveHashMap map) throws Exception {
        CaseInsensitiveHashMapTestCase.assertEquals((Object)"BAR", (Object)map.get((Object)"FOO"));
        CaseInsensitiveHashMapTestCase.assertEquals((Object)"BAR", (Object)map.get((Object)"foo"));
        CaseInsensitiveHashMapTestCase.assertEquals((Object)"BAR", (Object)map.get((Object)"Foo"));
        CaseInsensitiveHashMapTestCase.assertEquals((Object)3, (Object)map.get((Object)"DOO"));
        CaseInsensitiveHashMapTestCase.assertEquals((Object)3, (Object)map.get((Object)"doo"));
        CaseInsensitiveHashMapTestCase.assertEquals((Object)3, (Object)map.get((Object)"Doo"));
        CaseInsensitiveHashMapTestCase.assertEquals((int)2, (int)map.size());
        for (Object o : map.keySet()) {
            CaseInsensitiveHashMapTestCase.assertTrue((o.equals("FOO") || o.equals("DOO") ? 1 : 0) != 0);
            CaseInsensitiveHashMapTestCase.assertFalse((o.equals("foo") || o.equals("doo") ? 1 : 0) != 0);
        }
    }
}

