/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.FileUtils;

public class FileUtilsTestCase
extends AbstractMuleTestCase {
    private final String TEST_FILE = "testFile.txt";
    private final String TEST_DIRECTORY = "target" + File.separator + "testDirectory";
    private final File toDir = FileUtils.newFile((String)this.TEST_DIRECTORY);

    protected void doSetUp() throws Exception {
        super.doSetUp();
        if (!this.toDir.exists()) {
            this.toDir.mkdirs();
        }
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.toDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileTools() throws Exception {
        File file = null;
        try {
            file = FileUtils.stringToFile((String)"testFile.txt", (String)"this is a test file");
            FileUtilsTestCase.assertNotNull((Object)file);
            FileUtilsTestCase.assertTrue((boolean)file.exists());
            file = FileUtils.stringToFile((String)"testFile.txt", (String)" and this is appended content", (boolean)true);
            String content = FileUtils.readFileToString((File)FileUtils.newFile((String)"testFile.txt"), null);
            FileUtilsTestCase.assertNotNull((Object)content);
            FileUtilsTestCase.assertTrue((content.indexOf("this is a test file") > -1 ? 1 : 0) != 0);
            FileUtilsTestCase.assertTrue((content.indexOf(" and this is appended content") > -1 ? 1 : 0) != 0);
            file = FileUtils.newFile((String)"testFile.txt");
            FileUtilsTestCase.assertNotNull((Object)file);
            FileUtilsTestCase.assertTrue((boolean)file.exists());
            file = FileUtils.createFile((String)"testFile.txt");
            FileUtilsTestCase.assertNotNull((Object)file);
            FileUtilsTestCase.assertTrue((boolean)file.exists());
            file = FileUtils.createFile((String)"testFile.txt2");
            FileUtilsTestCase.assertNotNull((Object)file);
            FileUtilsTestCase.assertTrue((boolean)file.exists());
            FileUtilsTestCase.assertTrue((boolean)file.canRead());
            file.delete();
            file = FileUtils.newFile((String)"testFile.txt");
            file.delete();
            File dir = FileUtils.openDirectory((String)"src");
            FileUtilsTestCase.assertNotNull((Object)dir);
            FileUtilsTestCase.assertTrue((boolean)dir.exists());
            FileUtilsTestCase.assertTrue((boolean)dir.canRead());
            FileUtilsTestCase.assertTrue((boolean)dir.isDirectory());
            dir = FileUtils.openDirectory((String)"doesNotExist");
            FileUtilsTestCase.assertNotNull((Object)dir);
            FileUtilsTestCase.assertTrue((boolean)dir.exists());
            FileUtilsTestCase.assertTrue((boolean)dir.canRead());
            FileUtilsTestCase.assertTrue((boolean)dir.isDirectory());
            dir.delete();
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public void testFileNameTools() throws Exception {
        String filename = "Blah<Blah>.txt";
        String result = FileUtils.prepareWinFilename((String)filename);
        FileUtilsTestCase.assertEquals((String)"Blah(Blah).txt", (String)result);
        filename = "Bla]h<Blah:a;b|c?d=e_f*g>.txt";
        result = FileUtils.prepareWinFilename((String)filename);
        FileUtilsTestCase.assertEquals((String)"Bla-h(Blah-a-b-c-d=e_f-g).txt", (String)result);
        filename = "B\"la-h<Blah:a;b|c?d=e_f*g>.txt";
        result = FileUtils.prepareWinFilename((String)filename);
        FileUtilsTestCase.assertEquals((String)"B-la-h(Blah-a-b-c-d=e_f-g).txt", (String)result);
    }

    public void testDirectoryTools() throws Exception {
        File dir = FileUtils.openDirectory((String)"src");
        FileUtilsTestCase.assertNotNull((Object)dir);
        FileUtilsTestCase.assertTrue((boolean)dir.exists());
        FileUtilsTestCase.assertTrue((boolean)dir.canRead());
        FileUtilsTestCase.assertTrue((boolean)dir.isDirectory());
        dir = FileUtils.openDirectory((String)"doesNotExist");
        FileUtilsTestCase.assertNotNull((Object)dir);
        FileUtilsTestCase.assertTrue((boolean)dir.exists());
        FileUtilsTestCase.assertTrue((boolean)dir.canRead());
        FileUtilsTestCase.assertTrue((boolean)dir.isDirectory());
        FileUtils.deleteTree((File)dir);
    }

    public void testExtractResource() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-1";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            FileUtilsTestCase.assertTrue((String)"Failed to create output dirs.", (boolean)outputDir.mkdirs());
        }
        String res = "META-INF/MANIFEST.MF";
        FileUtils.extractResources((String)res, TestCase.class, (File)outputDir, (boolean)true);
        File result = FileUtils.newFile((String)testDir, (String)res);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isFile());
        FileUtilsTestCase.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteTree((File)outputDir);
    }

    public void testExtractResources() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-2";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String res = "META-INF/";
        FileUtils.extractResources((String)res, TestCase.class, (File)outputDir, (boolean)true);
        File result = FileUtils.newFile((String)testDir, (String)res);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isDirectory());
        FileUtils.deleteTree((File)outputDir);
    }

    public void testExtractFileResource() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-3";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String res = "org/mule/util/FileUtils.class";
        FileUtils.extractResources((String)res, FileUtils.class, (File)outputDir, (boolean)true);
        File result = FileUtils.newFile((String)testDir, (String)res);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isFile());
        FileUtilsTestCase.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteTree((File)outputDir);
    }

    public void testExtractFileResources() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-4";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String res = "org/mule/util/";
        FileUtils.extractResources((String)res, FileUtils.class, (File)outputDir, (boolean)true);
        File result = FileUtils.newFile((String)testDir, (String)res);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isDirectory());
        FileUtils.deleteTree((File)outputDir);
    }

    public void testExtractResourceWithoutKeepingDirStructure() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-5";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "MANIFEST.MF";
        String res = "META-INF/" + fileName;
        FileUtils.extractResources((String)res, TestCase.class, (File)outputDir, (boolean)false);
        File result = FileUtils.newFile((String)testDir, (String)fileName);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isFile());
        FileUtilsTestCase.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteTree((File)outputDir);
    }

    public void testExtractResourcesWithoutKeepingDirStructure() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-6";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "util/FileUtilsTestCase.class";
        String res = "org/mule/";
        FileUtils.extractResources((String)res, FileUtilsTestCase.class, (File)outputDir, (boolean)false);
        File result = FileUtils.newFile((String)testDir, (String)fileName);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isFile());
        FileUtilsTestCase.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteTree((File)outputDir);
    }

    public void testExtractFileResourceWithoutKeepingDirStructure() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-7";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "FileUtils.class";
        String res = "org/mule/util/" + fileName;
        FileUtils.extractResources((String)res, FileUtils.class, (File)outputDir, (boolean)false);
        File result = FileUtils.newFile((String)testDir, (String)fileName);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isFile());
        FileUtilsTestCase.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteTree((File)outputDir);
    }

    public void testExtractFileResourcesWithoutKeepingDirStructure() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-8";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = "util/FileUtilsTestCase.class";
        String res = "org/mule/";
        FileUtils.extractResources((String)res, FileUtilsTestCase.class, (File)outputDir, (boolean)false);
        File result = FileUtils.newFile((String)testDir, (String)fileName);
        FileUtilsTestCase.assertNotNull((Object)result);
        FileUtilsTestCase.assertTrue((boolean)result.exists());
        FileUtilsTestCase.assertTrue((boolean)result.canRead());
        FileUtilsTestCase.assertTrue((boolean)result.isFile());
        FileUtilsTestCase.assertTrue((result.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteTree((File)outputDir);
    }

    public void testDeleteTreeWithIgnoredDirectories() throws Exception {
        String testDir = this.TEST_DIRECTORY + File.separator + "Test-deleting";
        File outputDir = FileUtils.newFile((String)testDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File toBeDeleted1 = FileUtils.newFile((File)outputDir, (String)"toBeDeleted1/");
        toBeDeleted1.mkdirs();
        File toBeDeleted2 = FileUtils.newFile((File)outputDir, (String)"toBeDeleted2/");
        toBeDeleted2.mkdirs();
        File keepMeIntact = FileUtils.newFile((File)outputDir, (String)"keepMeIntact/");
        keepMeIntact.mkdirs();
        FileUtils.deleteTree((File)outputDir, (String[])new String[]{"keepMeIntact"});
        FileUtilsTestCase.assertTrue((String)"Shouldn't have been deleted.", (boolean)keepMeIntact.exists());
        FileUtils.deleteTree((File)outputDir);
    }

    public void testRenameFile() {
        try {
            File sourceFile = this.createTestFile("source");
            File destFile = this.createTestFile("dest");
            FileUtilsTestCase.assertTrue((boolean)destFile.delete());
            FileUtilsTestCase.assertTrue((boolean)FileUtils.renameFile((File)sourceFile, (File)destFile));
            FileUtilsTestCase.assertTrue((boolean)destFile.exists());
            FileUtilsTestCase.assertTrue((boolean)destFile.delete());
        }
        catch (Exception e) {
            FileUtilsTestCase.fail((String)e.getMessage());
        }
    }

    public void testRenameFileAcrossFolders() {
        try {
            File dir = this.createTestDir("test");
            File sourceFile = this.createTestFile("source");
            File destFile = new File(dir, "dest");
            FileUtilsTestCase.assertTrue((boolean)FileUtils.renameFile((File)sourceFile, (File)destFile));
            FileUtilsTestCase.assertTrue((boolean)destFile.exists());
            FileUtilsTestCase.assertTrue((boolean)destFile.delete());
            FileUtilsTestCase.assertTrue((boolean)dir.delete());
        }
        catch (Exception e) {
            FileUtilsTestCase.fail((String)e.getMessage());
        }
    }

    private File createTestFile(String filePath) throws IOException {
        return File.createTempFile(filePath, ".junit");
    }

    private File createTestDir(String dirPath) throws IOException {
        File file = this.createTestFile(dirPath);
        file.delete();
        file.mkdir();
        return file;
    }
}

