/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import junit.framework.TestCase;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;
import org.mule.util.SystemUtils;

public class FilenameUtilsTestCase
extends TestCase {
    public void testFileWithPathComponentsNullParameter() {
        File result = FilenameUtils.fileWithPathComponents(null);
        FilenameUtilsTestCase.assertNull((Object)result);
    }

    public void testFileWithNullElements() {
        File tempDir = this.getBuidDirectory();
        File result = FilenameUtils.fileWithPathComponents((String[])new String[]{tempDir.getAbsolutePath(), "tmp", null, "bar"});
        String resultNormalized = result.getAbsolutePath().replace(File.separatorChar, '|');
        String excpected = tempDir.getAbsolutePath().replace(File.separatorChar, '|') + "|tmp|bar";
        FilenameUtilsTestCase.assertEquals((String)excpected, (String)resultNormalized);
    }

    public void testFileWithPathComponents() {
        String tempDirPath = this.getBuidDirectory().getAbsolutePath();
        File result = FilenameUtils.fileWithPathComponents((String[])new String[]{tempDirPath, "tmp", "foo", "bar"});
        String resultNormalized = result.getAbsolutePath().replace(File.separatorChar, '|');
        String expected = tempDirPath.replace(File.separatorChar, '|') + "|tmp|foo|bar";
        FilenameUtilsTestCase.assertEquals((String)expected, (String)resultNormalized);
    }

    private File getBuidDirectory() {
        return FileUtils.newFile((File)SystemUtils.getUserDir(), (String)"target");
    }
}

