/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.HashMap;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

public class ObjectUtilsTestCase
extends AbstractMuleTestCase {
    public void testIdentityToShortString() {
        ObjectUtilsTestCase.assertEquals((String)"null", (String)ObjectUtils.identityToShortString(null));
        String source = "foo";
        String description = ObjectUtils.identityToShortString((Object)source);
        String[] components = StringUtils.split((String)description, (char)'@');
        ObjectUtilsTestCase.assertNotNull((Object)components);
        ObjectUtilsTestCase.assertEquals((int)2, (int)components.length);
        ObjectUtilsTestCase.assertEquals((String)"String", (String)components[0]);
        ObjectUtilsTestCase.assertEquals((String)Integer.toHexString(System.identityHashCode(source)), (String)components[1]);
    }

    public void testBooleanConversion() throws Exception {
        Object value = "true";
        ObjectUtilsTestCase.assertTrue((boolean)ObjectUtils.getBoolean((Object)value, (boolean)false));
        value = "xyz";
        ObjectUtilsTestCase.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (boolean)false));
        value = new Integer(6);
        ObjectUtilsTestCase.assertTrue((boolean)ObjectUtils.getBoolean((Object)value, (boolean)false));
        value = new Integer(1);
        ObjectUtilsTestCase.assertTrue((boolean)ObjectUtils.getBoolean((Object)value, (boolean)false));
        value = new Integer(0);
        ObjectUtilsTestCase.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (boolean)false));
        value = new Integer(-41);
        ObjectUtilsTestCase.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (boolean)false));
        value = null;
        ObjectUtilsTestCase.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (boolean)false));
    }

    public void testShortConversion() throws Exception {
        Object value = "123";
        ObjectUtilsTestCase.assertEquals((short)123, (short)ObjectUtils.getShort((Object)value, (short)-1));
        value = "xyz";
        ObjectUtilsTestCase.assertEquals((short)-1, (short)ObjectUtils.getShort((Object)value, (short)-1));
        value = new Integer(6);
        ObjectUtilsTestCase.assertEquals((short)6, (short)ObjectUtils.getShort((Object)value, (short)-1));
        value = new Double(63.4);
        ObjectUtilsTestCase.assertEquals((short)63, (short)ObjectUtils.getShort((Object)value, (short)-1));
        value = new Float(-163.2);
        ObjectUtilsTestCase.assertEquals((short)-163, (short)ObjectUtils.getShort((Object)value, (short)-1));
        value = null;
        ObjectUtilsTestCase.assertEquals((short)-1, (short)ObjectUtils.getShort((Object)value, (short)-1));
    }

    public void testByteConversion() throws Exception {
        Object value = "123";
        ObjectUtilsTestCase.assertEquals((byte)123, (byte)ObjectUtils.getByte((Object)value, (byte)-1));
        value = "xyz";
        ObjectUtilsTestCase.assertEquals((byte)-1, (byte)ObjectUtils.getByte((Object)value, (byte)-1));
        value = new Integer(6);
        ObjectUtilsTestCase.assertEquals((byte)6, (byte)ObjectUtils.getByte((Object)value, (byte)-1));
        value = new Double(63.4);
        ObjectUtilsTestCase.assertEquals((byte)63, (byte)ObjectUtils.getByte((Object)value, (byte)-1));
        value = new Float(-163.2);
        ObjectUtilsTestCase.assertEquals((byte)93, (byte)ObjectUtils.getByte((Object)value, (byte)-1));
        value = null;
        ObjectUtilsTestCase.assertEquals((byte)-1, (byte)ObjectUtils.getByte((Object)value, (byte)-1));
    }

    public void testIntConversion() throws Exception {
        Object value = "123";
        ObjectUtilsTestCase.assertEquals((int)123, (int)ObjectUtils.getInt((Object)value, (int)-1));
        value = "xyz";
        ObjectUtilsTestCase.assertEquals((int)-1, (int)ObjectUtils.getInt((Object)value, (int)-1));
        value = new Integer(6);
        ObjectUtilsTestCase.assertEquals((int)6, (int)ObjectUtils.getInt((Object)value, (int)-1));
        value = new Double(63.4);
        ObjectUtilsTestCase.assertEquals((int)63, (int)ObjectUtils.getInt((Object)value, (int)-1));
        value = new Float(-163.2);
        ObjectUtilsTestCase.assertEquals((int)-163, (int)ObjectUtils.getInt((Object)value, (int)-1));
        value = null;
        ObjectUtilsTestCase.assertEquals((int)-1, (int)ObjectUtils.getInt((Object)value, (int)-1));
    }

    public void testLongConversion() throws Exception {
        Object value = "123";
        ObjectUtilsTestCase.assertEquals((long)123L, (long)ObjectUtils.getLong((Object)value, (long)-1L));
        value = "xyz";
        ObjectUtilsTestCase.assertEquals((long)-1L, (long)ObjectUtils.getLong((Object)value, (long)-1L));
        value = new Integer(6);
        ObjectUtilsTestCase.assertEquals((long)6L, (long)ObjectUtils.getLong((Object)value, (long)-1L));
        value = new Double(63.4);
        ObjectUtilsTestCase.assertEquals((long)63L, (long)ObjectUtils.getLong((Object)value, (long)-1L));
        value = new Float(-163.2);
        ObjectUtilsTestCase.assertEquals((long)-163L, (long)ObjectUtils.getLong((Object)value, (long)-1L));
        value = null;
        ObjectUtilsTestCase.assertEquals((long)-1L, (long)ObjectUtils.getLong((Object)value, (long)-1L));
    }

    public void testFloatConversion() throws Exception {
        Object value = "123.34";
        ObjectUtilsTestCase.assertEquals((double)123.34, (double)ObjectUtils.getFloat((Object)value, (float)-1.0f), (double)0.1f);
        value = "xyz";
        ObjectUtilsTestCase.assertEquals((float)-1.0f, (float)ObjectUtils.getFloat((Object)value, (float)-1.0f), (float)0.1f);
        value = new Integer(6);
        ObjectUtilsTestCase.assertEquals((float)6.0f, (float)ObjectUtils.getFloat((Object)value, (float)-1.0f), (float)0.1f);
        value = new Double(63.4);
        ObjectUtilsTestCase.assertEquals((double)63.4, (double)ObjectUtils.getFloat((Object)value, (float)-1.0f), (double)0.1f);
        value = new Float(-163.2);
        ObjectUtilsTestCase.assertEquals((double)-163.2, (double)ObjectUtils.getFloat((Object)value, (float)-1.0f), (double)0.1f);
        value = null;
        ObjectUtilsTestCase.assertEquals((float)-1.0f, (float)ObjectUtils.getFloat((Object)value, (float)-1.0f), (float)0.1f);
    }

    public void testDoubleConversion() throws Exception {
        Object value = "123.34";
        ObjectUtilsTestCase.assertEquals((double)123.34, (double)ObjectUtils.getDouble((Object)value, (double)-1.0), (double)0.1);
        value = "xyz";
        ObjectUtilsTestCase.assertEquals((double)-1.0, (double)ObjectUtils.getDouble((Object)value, (double)-1.0), (double)0.1);
        value = new Integer(6);
        ObjectUtilsTestCase.assertEquals((double)6.0, (double)ObjectUtils.getDouble((Object)value, (double)-1.0), (double)0.1);
        value = new Double(63.4);
        ObjectUtilsTestCase.assertEquals((double)63.4, (double)ObjectUtils.getDouble((Object)value, (double)-1.0), (double)0.1);
        value = new Float(-163.2);
        ObjectUtilsTestCase.assertEquals((double)-163.2, (double)ObjectUtils.getDouble((Object)value, (double)-1.0), (double)0.1);
        value = null;
        ObjectUtilsTestCase.assertEquals((double)-1.0, (double)ObjectUtils.getDouble((Object)value, (double)-1.0), (double)0.1);
    }

    public void testStringConversion() throws Exception {
        Object value = "hello";
        ObjectUtilsTestCase.assertEquals((String)"hello", (String)ObjectUtils.getString((Object)value, (String)"x"));
        value = new HashMap();
        ObjectUtilsTestCase.assertEquals((String)new HashMap().toString(), (String)ObjectUtils.getString((Object)value, (String)"x"));
        value = null;
        ObjectUtilsTestCase.assertEquals((String)"x", (String)ObjectUtils.getString((Object)value, (String)"x"));
    }
}

