/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.Collection;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public class StringMessageUtilsTestCase
extends AbstractMuleTestCase {
    public void testToString() throws Exception {
        int i;
        Object test = "Oscar";
        String result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)"Oscar", (Object)result);
        test = this.getClass();
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)this.getClass().getName(), (Object)result);
        test = new TestObject("Ernie");
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)test.toString(), (Object)result);
        test = new AnotherTestObject("Bert");
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)"Bert", (Object)result);
        test = new String[]{"foo", "bar"};
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)"{foo,bar}", (Object)result);
        test = new byte[]{1, 2};
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)"{1,2}", (Object)result);
        test = new byte[150];
        for (i = 0; i < ((byte[])test).length; ++i) {
            ((byte[])test)[i] = (byte)i;
        }
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertTrue((boolean)result.endsWith("[..]}"));
        StringMessageUtilsTestCase.assertEquals((int)49, (int)StringUtils.countMatches((String)result, (String)","));
        test = new long[]{5068875495743534L, 457635546759674L};
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)"{5068875495743534,457635546759674}", (Object)result);
        test = new double[]{1.1, 2.02};
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertEquals((Object)"{1.1,2.02}", (Object)result);
        test = new ArrayList(100);
        for (i = 0; i < 100; ++i) {
            ((Collection)test).add(new Integer(i));
        }
        result = StringMessageUtils.toString((Object)test);
        StringMessageUtilsTestCase.assertTrue((boolean)result.endsWith("[..]]"));
        StringMessageUtilsTestCase.assertEquals((int)49, (int)StringUtils.countMatches((String)result, (String)","));
    }

    public void testFormattedString() throws Exception {
        String msg1 = "There is not substitution here";
        String result = StringMessageUtils.getFormattedMessage((String)msg1, null);
        StringMessageUtilsTestCase.assertEquals((String)msg1, (String)result);
        result = StringMessageUtils.getFormattedMessage((String)msg1, (Object[])new Object[0]);
        StringMessageUtilsTestCase.assertEquals((String)msg1, (String)result);
        String msg2 = "There should be a variable {0}, {1} and {2}";
        result = StringMessageUtils.getFormattedMessage((String)msg2, (Object[])new Object[]{"here", "there", "everywhere"});
        StringMessageUtilsTestCase.assertEquals((String)"There should be a variable here, there and everywhere", (String)result);
    }

    public void testBoilerPlateSingleLine() {
        String plate = StringMessageUtils.getBoilerPlate((String)"Single message.", (char)'*', (int)12);
        StringMessageUtilsTestCase.assertEquals((String)(SystemUtils.LINE_SEPARATOR + "************" + SystemUtils.LINE_SEPARATOR + "* Single   *" + SystemUtils.LINE_SEPARATOR + "* message. *" + SystemUtils.LINE_SEPARATOR + "************"), (String)plate);
    }

    public void testBoilerPlate() throws Exception {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("This");
        msgs.add("is a");
        msgs.add("Boiler Plate");
        String plate = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)12);
        StringMessageUtilsTestCase.assertEquals((String)(SystemUtils.LINE_SEPARATOR + "************" + SystemUtils.LINE_SEPARATOR + "* This     *" + SystemUtils.LINE_SEPARATOR + "* is a     *" + SystemUtils.LINE_SEPARATOR + "* Boiler   *" + SystemUtils.LINE_SEPARATOR + "* Plate    *" + SystemUtils.LINE_SEPARATOR + "************"), (String)plate);
    }

    public void testBoilerPlate2() throws Exception {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("This");
        msgs.add("is a");
        msgs.add("Boiler Plate Message that should get wrapped to the next line if it is working properly");
        String plate = StringMessageUtils.getBoilerPlate(msgs, (char)'*', (int)12);
        StringMessageUtilsTestCase.assertEquals((String)(SystemUtils.LINE_SEPARATOR + "************" + SystemUtils.LINE_SEPARATOR + "* This     *" + SystemUtils.LINE_SEPARATOR + "* is a     *" + SystemUtils.LINE_SEPARATOR + "* Boiler   *" + SystemUtils.LINE_SEPARATOR + "* Plate    *" + SystemUtils.LINE_SEPARATOR + "* Message  *" + SystemUtils.LINE_SEPARATOR + "* that     *" + SystemUtils.LINE_SEPARATOR + "* should   *" + SystemUtils.LINE_SEPARATOR + "* get      *" + SystemUtils.LINE_SEPARATOR + "* wrapped  *" + SystemUtils.LINE_SEPARATOR + "* to the   *" + SystemUtils.LINE_SEPARATOR + "* next     *" + SystemUtils.LINE_SEPARATOR + "* line if  *" + SystemUtils.LINE_SEPARATOR + "* it is    *" + SystemUtils.LINE_SEPARATOR + "* working  *" + SystemUtils.LINE_SEPARATOR + "* properly *" + SystemUtils.LINE_SEPARATOR + "************"), (String)plate);
    }

    public void testTruncate() {
        String msg = "this is a test message for truncating";
        String result = StringMessageUtils.truncate((String)msg, (int)100, (boolean)true);
        StringMessageUtilsTestCase.assertEquals((String)msg, (String)result);
        result = StringMessageUtils.truncate((String)msg, (int)10, (boolean)false);
        StringMessageUtilsTestCase.assertEquals((String)"this is a ...", (String)result);
        result = StringMessageUtils.truncate((String)msg, (int)10, (boolean)true);
        StringMessageUtilsTestCase.assertEquals((String)"this is a ...[10 of 37]", (String)result);
    }

    private class AnotherTestObject
    extends TestObject {
        public AnotherTestObject(String name) {
            super(name);
        }

        public String toString() {
            return this.getName();
        }
    }

    private class TestObject {
        private String name;

        public TestObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

