/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.MapUtils;
import org.mule.util.SystemUtils;

public class SystemUtilsTestCase
extends AbstractMuleTestCase {
    public void testEnvironment() throws Exception {
        String term;
        String envVarToTest;
        Map env = SystemUtils.getenv();
        SystemUtilsTestCase.assertNotNull((Object)env);
        SystemUtilsTestCase.assertFalse((boolean)env.isEmpty());
        SystemUtilsTestCase.assertSame((Object)env, (Object)SystemUtils.getenv());
        String string = envVarToTest = SystemUtils.IS_OS_WINDOWS ? "Path" : "PATH";
        if (SystemUtils.IS_OS_WINDOWS && (term = (String)env.get("TERM")) != null && term.contains("cygwin")) {
            envVarToTest = "PATH";
        }
        SystemUtilsTestCase.assertNotNull(env.get(envVarToTest));
    }

    public void testParsePropertyDefinitions() {
        Map expected = Collections.EMPTY_MAP;
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions(null));
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)""));
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)" "));
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"foo"));
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D"));
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D="));
        expected = Collections.singletonMap("-D", "true");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D-D"));
        expected = Collections.singletonMap("-D-D", "true");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D-D-D"));
        expected = Collections.singletonMap("-D-D-D", "true");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-D-D-D-D"));
        SystemUtilsTestCase.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"-D=noKey"));
        SystemUtilsTestCase.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"=-D"));
        SystemUtilsTestCase.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"foo =foo foo"));
        expected = Collections.singletonMap("k", "true");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)" -Dk "));
        expected = Collections.singletonMap("key", "true");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey"));
        expected = Collections.singletonMap("k", "v");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)" -Dk=v "));
        expected = Collections.singletonMap("key", "value");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=value"));
        expected = Collections.singletonMap("key", "quoted");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=\"quoted\""));
        expected = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new String[]{"key", "foo"}, (Object[])new String[]{"-Dvalue", "bar"});
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=-Dvalue -Dfoo=bar"));
        SystemUtilsTestCase.assertEquals((Object)Collections.EMPTY_MAP, (Object)SystemUtils.parsePropertyDefinitions((String)"-D=-Dfoo-D== =foo"));
        expected = Collections.singletonMap("key", "split value");
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)"-Dkey=\"split value\""));
        expected = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new String[]{"key1", "key2"}, (Object[])new String[]{"split one", "split two"});
        String input = "-Dkey1=\"split one\" -Dkey2=\"split two\" ";
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)input));
        expected = Collections.singletonMap("key", "open end");
        input = "-Dkey=\"open end";
        SystemUtilsTestCase.assertEquals(expected, (Object)SystemUtils.parsePropertyDefinitions((String)input));
        expected = MapUtils.mapWithKeysAndValues(HashMap.class, (Object[])new String[]{"keyOnly", "mule.foo", "mule.bar"}, (Object[])new String[]{"true", "xfoo", "xbar"});
        input = "  standalone key=value -D -D= -DkeyOnly -D=noKey -Dmule.foo=xfoo -Dmule.bar=xbar ";
        SystemUtilsTestCase.assertEquals((Object)expected, (Object)SystemUtils.parsePropertyDefinitions((String)input));
    }
}

