/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.compression;

import java.util.Arrays;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.compression.CompressionHelper;
import org.mule.util.compression.CompressionStrategy;

public class CompressionTestCase
extends AbstractMuleTestCase {
    public void testCompressDefaultGZip() throws Exception {
        String temp = "This is a compressed string";
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        byte[] compressed = strategy.compressByteArray(temp.getBytes());
        CompressionTestCase.assertTrue((compressed.length > temp.getBytes().length ? 1 : 0) != 0);
        byte[] uncompressed = strategy.uncompressByteArray(compressed);
        CompressionTestCase.assertTrue((uncompressed.length == temp.getBytes().length ? 1 : 0) != 0);
        CompressionTestCase.assertEquals((String)temp, (String)new String(uncompressed));
        String tempLarge = temp;
        for (int i = 0; i < 100; ++i) {
            tempLarge = tempLarge + temp;
        }
        compressed = strategy.compressByteArray(tempLarge.getBytes());
        CompressionTestCase.assertTrue((compressed.length < tempLarge.getBytes().length ? 1 : 0) != 0);
        uncompressed = strategy.uncompressByteArray(compressed);
        CompressionTestCase.assertTrue((uncompressed.length == tempLarge.getBytes().length ? 1 : 0) != 0);
        CompressionTestCase.assertEquals((String)tempLarge, (String)new String(uncompressed));
    }

    public void testNullIsCompressed() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        CompressionTestCase.assertFalse((boolean)strategy.isCompressed(null));
    }

    public void testEmptyIsCompressed() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        CompressionTestCase.assertFalse((boolean)strategy.isCompressed(new byte[0]));
    }

    public void testCompressNullBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        CompressionTestCase.assertNull((Object)strategy.compressByteArray(null));
    }

    public void testCompressEmptyBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        byte[] bytes = new byte[]{};
        byte[] result = strategy.compressByteArray(bytes);
        CompressionTestCase.assertTrue((boolean)strategy.isCompressed(result));
    }

    public void testUncompressNullBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        CompressionTestCase.assertNull((Object)strategy.uncompressByteArray(null));
    }

    public void testUncompressEmptyBytes() throws Exception {
        CompressionStrategy strategy = CompressionHelper.getDefaultCompressionStrategy();
        byte[] bytes = new byte[]{};
        byte[] cmpbytes = strategy.compressByteArray(bytes);
        CompressionTestCase.assertTrue((boolean)strategy.isCompressed(cmpbytes));
        byte[] result = strategy.uncompressByteArray(cmpbytes);
        CompressionTestCase.assertTrue((boolean)Arrays.equals(bytes, result));
    }
}

