/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.pool;

import java.util.NoSuchElementException;
import org.mule.api.MuleContext;
import org.mule.api.object.ObjectFactory;
import org.mule.config.PoolingProfile;
import org.mule.tck.testmodels.fruit.BananaFactory;
import org.mule.util.pool.AbstractPoolingTestCase;
import org.mule.util.pool.CommonsPoolObjectPool;
import org.mule.util.pool.ObjectPool;

public class CommonsPoolObjectPoolTestCase
extends AbstractPoolingTestCase {
    public void testPoolExhaustedFail() throws Exception {
        ObjectPool pool = this.createPoolWithExhaustedAction(0);
        CommonsPoolObjectPoolTestCase.assertEquals((int)0, (int)pool.getNumActive());
        this.borrowObjectsUntilPoolIsFull(pool);
        try {
            pool.borrowObject();
            CommonsPoolObjectPoolTestCase.fail((String)"borrowing an object from a pool with policy WHEN_EXHAUSTED_FAIL must fail");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testPoolExhaustedGrow() throws Exception {
        ObjectPool pool = this.createPoolWithExhaustedAction(2);
        CommonsPoolObjectPoolTestCase.assertEquals((int)0, (int)pool.getNumActive());
        this.borrowObjectsUntilPoolIsFull(pool);
        pool.borrowObject();
        CommonsPoolObjectPoolTestCase.assertEquals((int)4, (int)pool.getNumActive());
    }

    public void testPoolExhaustedWait() throws Exception {
        ObjectPool pool = this.createPoolWithExhaustedAction(1);
        CommonsPoolObjectPoolTestCase.assertEquals((int)0, (int)pool.getNumActive());
        this.borrowObjectsUntilPoolIsFull(pool);
        long before = System.currentTimeMillis();
        try {
            pool.borrowObject();
            CommonsPoolObjectPoolTestCase.fail((String)"WHEN_EXHAUSTED_WAIT was specified but the pool returned an object");
        }
        catch (NoSuchElementException nse) {
            long delta = System.currentTimeMillis() - before;
            CommonsPoolObjectPoolTestCase.assertTrue((delta >= 1500L ? 1 : 0) != 0);
        }
    }

    public void testInitPoolNone() throws Exception {
        ObjectPool pool = this.createPoolWithInitialisationPolicy(0);
        CountingObjectFactory objectFactory = (CountingObjectFactory)pool.getObjectFactory();
        CommonsPoolObjectPoolTestCase.assertEquals((int)0, (int)objectFactory.getInstanceCount());
    }

    public void testInitPoolOne() throws Exception {
        ObjectPool pool = this.createPoolWithInitialisationPolicy(1);
        CountingObjectFactory objectFactory = (CountingObjectFactory)pool.getObjectFactory();
        CommonsPoolObjectPoolTestCase.assertEquals((int)1, (int)objectFactory.getInstanceCount());
    }

    public void testInitPoolAll() throws Exception {
        ObjectPool pool = this.createPoolWithInitialisationPolicy(2);
        CountingObjectFactory objectFactory = (CountingObjectFactory)pool.getObjectFactory();
        CommonsPoolObjectPoolTestCase.assertEquals((int)3, (int)objectFactory.getInstanceCount());
    }

    private ObjectPool createPoolWithExhaustedAction(int exhaustedAction) throws Exception {
        PoolingProfile poolingProfile = this.createDefaultPoolingProfile();
        poolingProfile.setExhaustedAction(exhaustedAction);
        BananaFactory objectFactory = new BananaFactory();
        return this.createPool(poolingProfile, objectFactory);
    }

    private ObjectPool createPoolWithInitialisationPolicy(int initPolicy) throws Exception {
        PoolingProfile poolingProfile = this.createDefaultPoolingProfile();
        poolingProfile.setInitialisationPolicy(initPolicy);
        CountingObjectFactory objectFactory = new CountingObjectFactory();
        return this.createPool(poolingProfile, objectFactory);
    }

    private ObjectPool createPool(PoolingProfile poolingProfile, ObjectFactory objectFactory) throws Exception {
        CommonsPoolObjectPool pool = new CommonsPoolObjectPool(objectFactory, poolingProfile, muleContext);
        pool.initialise();
        return pool;
    }

    private void borrowObjectsUntilPoolIsFull(ObjectPool pool) throws Exception {
        for (int i = 1; i <= 3; ++i) {
            pool.borrowObject();
            CommonsPoolObjectPoolTestCase.assertEquals((int)i, (int)pool.getNumActive());
        }
    }

    private static class CountingObjectFactory
    extends BananaFactory {
        private int instanceCount = 0;

        private CountingObjectFactory() {
        }

        public Object getInstance(MuleContext muleContext) throws Exception {
            ++this.instanceCount;
            return super.getInstance(muleContext);
        }

        public int getInstanceCount() {
            return this.instanceCount;
        }
    }
}

