/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTServletWithParams
extends HttpServlet {
    public static final String FS = System.getProperty("file.separator");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            String xml = this.getRequestParam(request, "URL");
            String xsl = this.getRequestParam(request, "xslURL");
            StreamSource xmlSource = null;
            Source xslSource = null;
            Transformer transformer = null;
            String ctx = this.getServletContext().getRealPath("") + FS;
            if (xml != null && xml.length() > 0) {
                xmlSource = new StreamSource(new URL("file", "", ctx + xml).openStream());
            }
            if (xsl != null && xsl.length() > 0) {
                xslSource = new StreamSource(new URL("file", "", ctx + xsl).openStream());
            }
            if (xmlSource != null) {
                if (xslSource == null) {
                    String media = null;
                    String title = null;
                    String charset = null;
                    xslSource = tFactory.getAssociatedStylesheet(xmlSource, media, title, charset);
                }
                if (xslSource != null) {
                    transformer = tFactory.newTransformer(xslSource);
                    this.setParameters(transformer, request);
                    transformer.transform(xmlSource, new StreamResult(out));
                } else {
                    out.write("No Stylesheet!");
                }
            } else {
                out.write("No XML Input Document!");
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
        out.close();
    }

    String getRequestParam(HttpServletRequest request, String param) {
        if (request != null) {
            String paramVal = request.getParameter(param);
            return paramVal;
        }
        return null;
    }

    void setParameters(Transformer transformer, HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            try {
                String paramVal = request.getParameter(paramName);
                if (paramVal == null) continue;
                transformer.setParameter(paramName, paramVal);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

